// ---------------------------------------------------------------------------
//
// (c) Copyright 2010, Allan Petersen
// ALL RIGHTS RESERVED
// Permission to use, copy, modify, and distribute this software for
// any purpose and without fee is hereby granted, provided that the above
// copyright notice appear in all copies and that both the copyright notice
// and this permission notice appear in supporting documentation, and that
// the name of Allan Petersen not be used in advertising
// or publicity pertaining to distribution of the software without specific,
// written prior permission.
//
// THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS"
// AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
// INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR
// FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL ALLAN
// PETERSEN BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,
// SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY
// KIND, OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION,
// LOSS OF PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF
// THIRD PARTIES, WHETHER OR NOT ALLAN PETERSEN HAS BEEN
// ADVISED OF THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE
// POSSESSION, USE OR PERFORMANCE OF THIS SOFTWARE.
//
// www.allanpetersen.com
//
//
// ---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "c_uac.h"
#include "Unit1.h"
// ---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

// ---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{

}

// ---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStatusClick(TObject *Sender)
{
	ValueListEditor1->Cells[1][1] = TUAC().IsElevated() ? "True" : "False";

	// Get and display the process integrity level.
	DWORD const dwIntegrityLevel = TUAC().IntegrityLevel;
	switch(dwIntegrityLevel)
	{
	case SECURITY_MANDATORY_UNTRUSTED_RID:
		ValueListEditor1->Cells[1][2] = "Untrusted";
		break;
	case SECURITY_MANDATORY_LOW_RID:
		ValueListEditor1->Cells[1][2] = "Low";
		break;
	case SECURITY_MANDATORY_MEDIUM_RID:
		ValueListEditor1->Cells[1][2] = "Medium";
		break;
	case SECURITY_MANDATORY_HIGH_RID:
		ValueListEditor1->Cells[1][2] = "High";
		break;
	case SECURITY_MANDATORY_SYSTEM_RID:
		ValueListEditor1->Cells[1][2] = "System";
		break;
	default:
		ValueListEditor1->Cells[1][2] = "Unknown";
		break;
	}

	ValueListEditor1->Cells[1][3] = TUAC().IsRunAsAdmin() ? "True" : "False";
	ValueListEditor1->Cells[1][4] = TUAC().IsUserInAdminGroup()	? "True" : "False";

}
// ---------------------------------------------------------------------------
